// GpPenEscT.cpp : implementation file
//

#include "stdafx.h"
#include "defsfile.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGpPenEscT Dialog


CGpPenEscT::CGpPenEscT(CWnd* pParent /*=NULL*/)
	: CIndecateString (CGpPenEscT::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGpPenEscT)
	m_cFontSize = 0 ;
	m_szString = _T("");
	//}}AFX_DATA_INIT

	m_bAction = FALSE ;
	Create(IDD,pParent);
}


void CGpPenEscT::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGpPenEscT)
	DDX_CBIndex(pDX, IDC_cFontSize, m_cFontSize);
	DDX_Text(pDX, IDC_szString, m_szString);
	DDV_MaxChars(pDX, m_szString, 99);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGpPenEscT, CDialog)
	//{{AFX_MSG_MAP(CGpPenEscT)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGpPenEscT Message Handler

void CGpPenEscT::PostNcDestroy() 
{
	CDialog::PostNcDestroy();
	delete this ;
}


//	Get string size from dialog data
//
//  return FALSE:Error TRUE:OK
BOOL CGpPenEscT::GetActionSize()
{
	UpdateData(TRUE);

	if( m_szString.IsEmpty() )
		return FALSE ;

	m_sActionSize.cx = (8 * m_szString.GetLength()) << (m_cFontSize /  4) ; 
	m_sActionSize.cy = -(16 << (m_cFontSize %  4)) ;
	return( TRUE );
}


// Create Content
CContents*  CGpPenEscT::CreateContents()
{
	// Create empty content
	CContentsEscT* pContents = new CContentsEscT();

	// Set the data from dialog
	UpdateData(TRUE);
	pContents->m_Data.cDisplayColor = theApp.m_cDisplayColor  ;
	pContents->m_Data.cBackColor = theApp.m_cBackColor  ;

	pContents->m_Data.cFontSize = (m_cFontSize / 4) | ((m_cFontSize % 4 ) << 4) ;
	strncpy(pContents->m_Data.szString,(LPCTSTR)m_szString,MEMLNK_ESC_T_MAX) ;
	pContents->m_Data.szString[MEMLNK_ESC_T_MAX] = 0 ;


	// Set Content the display position
	pContents->m_Data.iX1 = m_iX1 ;
	pContents->m_Data.iY1 = m_iY1 ;
	return( pContents );
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Draw String
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Erase drawing
void CIndecateString::ActionErase(CDC* pDC)
{
	if( m_bAction ){
		InvertBox(pDC,m_iX1,m_iY1,m_iX1+m_sActionSize.cx,m_iY1+m_sActionSize.cy) ;
		m_bAction = FALSE ;
	}
}

// Draw to the new position
void CIndecateString::ActionDisplay(CPoint NewPoint,CDC* pDC)
{
	// Erase
	ActionErase(pDC);

	// Draw at new position
	m_iX1 = NewPoint.x ;
	m_iY1 = NewPoint.y ;
	InvertBox(pDC,m_iX1,m_iY1,m_iX1+m_sActionSize.cx,m_iY1+m_sActionSize.cy) ;
	m_bAction = TRUE ;
}


// Start Drawing
int  CIndecateString::ActionDown(UINT nFlags, CPoint point,CDC* pDC)
{

	if( !GetActionSize() ){
		// Nothing to draw
		AfxMessageBox(IDS_NOTHING_STRING) ;
		return( B_ActionStop );
	}

	// Draw
	ActionDisplay(point,pDC) ;

	return( B_ActionContinue );	// Continue
}


// Move
int  CIndecateString::ActionMove(UINT nFlags, CPoint point,CDC* pDC)
{
	ActionDisplay(point,pDC) ;

	return( B_ActionContinue );	// Continue
}

// End
int  CIndecateString::ActionUp(UINT nFlags, CPoint point,CDC* pDC)
{
	ActionDisplay(point,pDC) ;

	ActionErase(pDC) ;

	return( B_ActionOk );
}

// Cancel
int  CIndecateString::ActionCancel(CDC* pDC)
{
	ActionErase(pDC) ;

	return( B_ActionStop );
}

